/*---------------------------------------------------------------------------*\

    FILE....: TSCR.CPP
    TYPE....: C++ program
    AUTHOR..: David Rowe
    DATE....: 9/2/01

    Test program for set_codec_reg().

    This program is intended to be linked with the vpb 1.6.x Linux libraries.

    Compile: gcc tscr.cpp -lvpb -g -Wall -o tscr -lm -pthread
    Run....: ./tscr

\*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*\

         Voicetronix Voice Processing Board (VPB) Software

         Copyright (C) 1999-2001 Voicetronix www.voicetronix.com.au

         This library is free software; you can redistribute it and/or
         modify it under the terms of the GNU Lesser General Public
         License as published by the Free Software Foundation; either
         version 2.1 of the License, or (at your option) any later version.

         This library is distributed in the hope that it will be useful,
         but WITHOUT ANY WARRANTY; without even the implied warranty of
         MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
         Lesser General Public License for more details.

         You should have received a copy of the GNU Lesser General Public
         License along with this library; if not, write to the Free Software
         Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
	 USA

\*---------------------------------------------------------------------------*/

#include <assert.h>
#include <stdlib.h>
#include <stdio.h>
#include <math.h>

#include "../src/vpbapi.h"
#include "../src/verbose.h"

void vpb_set_codec_reg(int chdev,    // channel handle
		       unsigned short addr,  // 8-bit address of codec register
		       unsigned short data   // 8-bit data to write to register
		      );

int main(int argc, char * argv[])
{
	int	        h;

	verbose(1);
	vpb_seterrormode(VPB_DEVELOPMENT);

	h = vpb_open(1,1);
       	vpb_sethook_sync(h,VPB_OFFHOOK);
	vpb_sleep(1000);

	// place back on-hook by directly writing to register
	//vpb_sethook_sync(h, VPB_ONHOOK);
	vpb_set_codec_reg(h, 0x0a, 0x00);
	vpb_sleep(1000);

	vpb_close(h);

	return 0;
}



